/**************************************************************************
 * 
 * Group sketchpad example, using both cursor and sketching overlays on
 * top of an empty glyph.  A "Pic" glyph is provided so that the program
 * can do the sketchpad on top of an arbitrary TIFF image.
 * 
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */


 
#include <gk/groupsession.h>
#include <InterViews/window.h>
#include <stdio.h>
#include <gk/cursor.h>
#include <gk/sketchpad.h>
#include "emptyglyph.h"
#include <gk/confglyph.h>
#include <InterViews/tiff.h>
#include <InterViews/image.h>
#include <IV-look/kit.h>
#include <InterViews/layout.h>

class Pic : public ConferenceGlyph {
public:
  Pic(Style*, Conference*, char*);
};

Pic::Pic(Style* style, Conference* conf, char* fname) : ConferenceGlyph(nil, style, conf) {
  Raster* r = TIFFRaster::load(fname);
  body( WidgetKit::instance()->inset_frame( new Image(r)));
}


int main(int argc, char** argv) {
  GroupSession* session = new GroupSession("CursorDemo", argc, argv);
  Conference* confer = session->conference();
  session->run_window( 
    new ApplicationWindow(
       WidgetKit::instance()->inset_frame( LayoutKit::instance()->margin(
              new CursorOverlay( 
                new Sketchpad(
//	           new Pic(session->style(), confer, "calvin.hobbes.tif")
	           new EmptyGlyph(session->style(), confer, 300,300)
                   ,session->style(), confer
                )
	        ,session->style(), confer
              )
        , 30.0))
    )
  );
}

