/****************************************************************************
 * 
 * Class:  MsgSender implementation
 * Author: Mark Roseman
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 02/17/92 MR        initial version
 * 08/14/92 MR        clean up
 * 
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include <gk/writer.h>
#include <gk/msgsender.h>
#include <string.h>

/****************************************************************************
 *
 * subclass must define both the constructor and the sendOn method.
 *
 ****************************************************************************/

MsgSender::MsgSender() {}


/****************************************************************************
 *
 * Constructor for string message sender.
 *
 ****************************************************************************/

StrMsgSender::StrMsgSender(int c, char *m) : code(c) {
  msg = strdup(m);       /* MEMORY LEAK */
}

/****************************************************************************
 * 
 * Send string message.
 *
 ****************************************************************************/

void StrMsgSender::sendOn(Writer* w) {  w->sendMsg(code,msg); }
